package hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.TicTacToeApplication;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.controller.TicTacToeMainController;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.PlayerType;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;

import java.io.*;

public class GameUtils {

    public static final Integer NUMBER_OF_ROWS = 3;
    public static final Integer NUMBER_OF_COLUMNS = 3;
    private static final String SAVE_GAME_FILE_PATH = "game/save.dat";

    public static void startNewGame(Button[][] board) {

        TicTacToeMainController.gameNumber++;

        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setText("");
            }
        }

        TicTacToeMainController.turn = TicTacToeMainController.gameNumber % 2 != 0 ? Symbol.O : Symbol.X;

        GameState gameState = generateGameState(board, TicTacToeMainController.turn, true, 0);

        if(!TicTacToeApplication.playerType.name().equals(PlayerType.SINGLE_PLAYER.name())) {
            TicTacToeApplication.sendRequestPlayerOne(gameState);
            GameState alternateGameState = generateGameState(board,
                    gameState.getTurn().equals(Symbol.X) ? Symbol.O : Symbol.X, true, 0);
            TicTacToeApplication.sendRequestPlayerTwo(alternateGameState);
        }

        /*
        if(TicTacToeApplication.playerType.name().equals(PlayerType.PLAYER_1.name())) {
            TicTacToeApplication.sendRequestPlayerOne(gameState);
        }
        else if(TicTacToeApplication.playerType.name().equals(PlayerType.PLAYER_2.name())) {
            TicTacToeApplication.sendRequestPlayerTwo(gameState);
        }

         */
    }

    public static boolean winnerExists(Button[][] board, Symbol turn) {

        boolean winnerExists = false;

        for (int i = 0; i < GameUtils.NUMBER_OF_COLUMNS; i++) {
            if (board[i][0].getText().equals(turn.name()) &&
                    board[i][1].getText().equals(turn.name()) &&
                    board[i][2].getText().equals(turn.name())) {
                //winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
                return true;
            }

            if (board[0][i].getText().equals(turn.name()) &&
                    board[1][i].getText().equals(turn.name()) &&
                    board[2][i].getText().equals(turn.name())) {
                //winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
                return true;
            }
        }

        if (board[0][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[2][2].getText().equals(turn.name())) {
            //winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
            return true;
        }

        if (board[2][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[0][2].getText().equals(turn.name())) {
            //winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
            return true;
        }
        return winnerExists;
    }

    public static boolean winnerExists(String[][] board, Symbol turn) {

        boolean winnerExists = false;

        for (int i = 0; i < GameUtils.NUMBER_OF_COLUMNS; i++) {
            if (board[i][0].equals(turn.name()) &&
                    board[i][1].equals(turn.name()) &&
                    board[i][2].equals(turn.name())) {
                //winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
                return true;
            }

            if (board[0][i].equals(turn.name()) &&
                    board[1][i].equals(turn.name()) &&
                    board[2][i].equals(turn.name())) {
                //winnerExists = true;
                Platform.runLater(() ->
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION));
                return true;
            }
        }

        if (board[0][0].equals(turn.name()) &&
                board[1][1].equals(turn.name()) &&
                board[2][2].equals(turn.name())) {
            //winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
            return true;
        }

        if (board[2][0].equals(turn.name()) &&
                board[1][1].equals(turn.name()) &&
                board[0][2].equals(turn.name())) {
            //winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
            return true;
        }
        return winnerExists;
    }

    public static void saveGame(GameState gameState) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SAVE_GAME_FILE_PATH))) {
            oos.writeObject(gameState);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GameState loadGame() {
        GameState loadedGameState;
        try(ObjectInputStream ois = new ObjectInputStream(new FileInputStream(SAVE_GAME_FILE_PATH))) {
            loadedGameState =  (GameState) ois.readObject();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }

        return loadedGameState;
    }

    public static GameState generateGameState(Button[][] board, Symbol turn, Boolean newGame, Integer numberOfTurns) {
        String[][] symbolBoard = new String[NUMBER_OF_ROWS][NUMBER_OF_COLUMNS];

        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                symbolBoard[i][j] = board[i][j].getText();
            }
        }

        GameState gameStateToSave = new GameState(symbolBoard, turn, newGame, numberOfTurns);
        return gameStateToSave;
    }

}
