package hr.algebra.trirp1.tictactoe.tictactoe3rp11.model;

import java.io.Serializable;
import java.util.Objects;

public class GameMove implements Serializable {
    private Symbol symbol;
    private Position position;

    public GameMove() {
    }

    public GameMove(Symbol symbol, Position position) {
        this.symbol = symbol;
        this.position = position;
    }

    public Symbol getSymbol() {
        return symbol;
    }

    public void setSymbol(Symbol symbol) {
        this.symbol = symbol;
    }

    public Position getPosition() {
        return position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GameMove gameMove = (GameMove) o;
        return Objects.equals(symbol, gameMove.symbol) && Objects.equals(position, gameMove.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(symbol, position);
    }

    @Override
    public String toString() {
        return "GameMove{" +
                "symbol=" + symbol +
                ", position=" + position +
                '}';
    }
}
