package hr.algebra.trirp1.tictactoe.tictactoe3rp11.utils;

import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.GameState;
import hr.algebra.trirp1.tictactoe.tictactoe3rp11.model.Symbol;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;

import java.io.*;

public class GameUtils {

    public static final Integer NUMBER_OF_ROWS = 3;
    public static final Integer NUMBER_OF_COLUMNS = 3;
    private static final String SAVE_GAME_FILE_PATH = "game/save.dat";

    public static void startNewGame(Button[][] board) {
        for (int i = 0; i < NUMBER_OF_ROWS; i++) {
            for (int j = 0; j < NUMBER_OF_COLUMNS; j++) {
                board[i][j].setText("");
            }
        }
    }

    public static boolean winnerExists(Button[][] board, Symbol turn) {

        boolean winnerExists = false;

        for (int i = 0; i < GameUtils.NUMBER_OF_COLUMNS; i++) {
            if (board[i][0].getText().equals(turn.name()) &&
                    board[i][1].getText().equals(turn.name()) &&
                    board[i][2].getText().equals(turn.name())) {
                winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
            }

            if (board[0][i].getText().equals(turn.name()) &&
                    board[1][i].getText().equals(turn.name()) &&
                    board[2][i].getText().equals(turn.name())) {
                winnerExists = true;
                DialogUtils.showDialog("Pobijedio je " + turn.name(),
                        "Pobjednik je igrač koji koristi simbol " + turn.name(),
                        Alert.AlertType.INFORMATION);
            }
        }

        if (board[0][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[2][2].getText().equals(turn.name())) {
            winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
        }

        if (board[2][0].getText().equals(turn.name()) &&
                board[1][1].getText().equals(turn.name()) &&
                board[0][2].getText().equals(turn.name())) {
            winnerExists = true;
            DialogUtils.showDialog("Pobijedio je " + turn.name(),
                    "Pobjednik je igrač koji koristi simbol " + turn.name(),
                    Alert.AlertType.INFORMATION);
        }
        return winnerExists;
    }

    public static void saveGame(GameState gameState) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SAVE_GAME_FILE_PATH))) {
            oos.writeObject(gameState);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GameState loadGame() {
        GameState loadedGameState;
        try(ObjectInputStream ois = new ObjectInputStream(new FileInputStream(SAVE_GAME_FILE_PATH))) {
            loadedGameState =  (GameState) ois.readObject();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }

        return loadedGameState;
    }

}
