﻿using exercise_04_01.Models;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace exercise_04_01.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class NotificationsController : ControllerBase
    {
        private readonly Exercise4Context _context;

        public NotificationsController(Exercise4Context context)
        {
            _context = context;
        }

        // GET: api/<NotificationsController>
        [HttpGet]
        public ActionResult<IEnumerable<Notification>> Get()
        {
            try
            {
                return Ok(_context.Notifications);
            }
            catch (Exception ex)
            {
                return StatusCode(500, ex.Message);
            }
        }

        // GET api/<NotificationsController>/5
        [HttpGet("{id}")]
        public ActionResult<Notification> Get(int id)
        {
            try
            {
                var result = _context.Notifications.Include(x => x.NotificationType).FirstOrDefault(x => x.Id == id);

                return Ok(result);
            }
            catch (Exception ex)
            {
                return StatusCode(500, ex.Message);
            }
        }

        // POST api/<NotificationsController>
        [HttpPost]
        public void Post([FromBody] string value)
        {
        }

        // PUT api/<NotificationsController>/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/<NotificationsController>/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }
    }
}
