﻿using exercise_14.Models;
using exercise_14.ViewModels;
using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Mvc;

namespace exercise_14.Controllers
{
    public class FileController : Controller
    {
        private readonly Exercise14Context _context;

        public FileController(Exercise14Context context)
        {
            _context = context;
        }

        public IActionResult Index()
        {
            return View();
        }

        public IActionResult Upload()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Upload(UploadFilesVM uploadVm)
        {
            // Create upload folder for user
            var baseUploadPath = Path.GetFullPath("wwwroot/upload");
            var userName = HttpContext.User.Identity.Name;
            var userUploadPath = Path.Combine(baseUploadPath, userName);

            if (!System.IO.Directory.Exists(userUploadPath))
            {
                System.IO.Directory.CreateDirectory(userUploadPath);
            }

            // Upload file to temp file
            // Then copy temp file to the destination file
            foreach (var uploadFile in uploadVm.Files)
            {
                UploadToUserFolder(userUploadPath, uploadFile);
                _context.Documents.Add(new Document
                {
                    AudioId = 2,
                    FileName = uploadFile.FileName
                });
                _context.SaveChanges();
            }

            return RedirectToAction();
        }

        public IActionResult Download()
        {
            var basePath = "/upload";
            var userName = HttpContext.User.Identity.Name;
            var userPath = Path.Combine(basePath, userName);

            var fileNames = _context.Documents.Select(x => new DownloadFileVM { 
                Filename = x.FileName,
                DownloadUri = Path.Combine(userPath, x.FileName)
            });
            var downloadFiles = 
                new DownloadFilesVM
                {
                    Files = fileNames.ToList()
                };
            return View(downloadFiles);
        }

        private static void UploadToUserFolder(string userUploadPath, IFormFile uploadFile)
        {
            var tempFilePath = Path.GetTempFileName();

            using (var stream = System.IO.File.Create(tempFilePath))
            {
                uploadFile.CopyTo(stream);
            }

            var targetUploadPath = Path.Combine(userUploadPath, uploadFile.FileName);

            // !Will overwrite if names are the same!
            System.IO.File.Copy(tempFilePath, targetUploadPath, true);
        }
    }
}
