﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace exercise_3_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class CollectionController : ControllerBase
    {
        private static List<int> State { get; set; } = new();

        [HttpPost("[action]")]
        public ActionResult AddToState(int[] numbers)
        {
            try
            {
                State.AddRange(numbers);

                return Ok();
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpGet("[action]")]
        public ActionResult<List<int>> GetState()
        {
            try
            {
                return Ok(State);
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpPost("[action]")]
        public ActionResult AddSingleToState(int number)
        {
            try
            {
                State.Add(number);

                return Ok();
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpDelete("[action]")]
        public ActionResult RemoveFromState(int number)
        {
            try
            {
                State.RemoveAll(n => n == number);

                return Ok();
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }
    }
}
