﻿using Microsoft.AspNetCore.Mvc.ModelBinding.Validation;
using Microsoft.DotNet.Scaffolding.Shared.Messaging;
using System.ComponentModel.DataAnnotations;

namespace exercise_10_1.ViewModels
{
    public class SongVM
    {
        public int Id { get; set; }
        [Display(Name = "Song Name")]
        [Required(ErrorMessage = "There's not much sense of having a song without the name, right?")]
        public string Name { get; set; }
        [Range(1000, 2024, ErrorMessage = "Invalid year for a song")]
        public int Year { get; set; }
        [Display(Name = "Select Genre")]
        public int GenreId { get; set; }
        [Display(Name = "Genre")]
        [ValidateNever]
        public string GenreName { get; set; }
        [Display(Name = "Select Artist")]
        public int ArtistId { get; set; }
        [Display(Name = "Artist")]
        [ValidateNever]
        public string ArtistName { get; set; }
    }
}
