﻿using exercise_9_1.Models;
using exercise_9_1.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;

namespace exercise_9_1.Controllers
{
    public class SongController : Controller
    {
        private readonly Exercise9Context _context;

        public SongController(Exercise9Context context)
        {
            _context = context;
        }

        // GET: SongController
        public ActionResult Index()
        {
            ViewBag.Songs = _context.Songs;
            ViewBag.ExampleText = "Some text";
            ViewBag.ExampleNumber = 1987;
            ViewBag.Genres = _context.Genres;
            ViewBag.GenreDropDownItems =
                _context.Genres.Select(x => new SelectListItem { Text = x.Name, Value = x.Id.ToString() });

            return View();
        }

        [HttpPost]
        public ActionResult Index(string ExampleText, int ExampleNumber, int GenreDropDownItems)
        {
            return RedirectToAction();
        }

        // GET: SongController/Details/5
        public ActionResult Details(int id)
        {
            var song = _context.Songs.Include(x => x.Genre).FirstOrDefault(x => x.Id == id);

            // Map to VM
            var songVM = new SongVM
            {
                Id = song.Id,
                Name = song.Name,
                Year = song.Year,
                GenreId = song.GenreId,
                GenreName = song.Genre.Name,
                IsActive = !song.DeletedAt.HasValue,
            };

            return View(songVM);
        }

        // GET: SongController/Create
        public ActionResult Create()
        {
            ViewBag.GenreSelect =
              _context.Genres.Select(x => new SelectListItem { Text = x.Name, Value = x.Id.ToString() });

            return View();
        }

        // POST: SongController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(SongVM song)
        {
            try
            {
                var newSong = new Song
                {
                    Name = song.Name,
                    Year = song.Year,
                    GenreId = song.GenreId,
                    DeletedAt = song.IsActive ? null : DateTime.UtcNow
                };

                _context.Songs.Add(newSong);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Edit/5
        public ActionResult Edit(int id)
        {
            ViewBag.GenreSelect =
              _context.Genres.Select(x => new SelectListItem { Text = x.Name, Value = x.Id.ToString() });

            var song = _context.Songs.FirstOrDefault(x => x.Id == id);

            // Map to VM
            var songVM = new SongVM
            {
                Id = song.Id,
                Name = song.Name,
                Year = song.Year,
                GenreId = song.GenreId,
                IsActive = !song.DeletedAt.HasValue,
            };

            return View(songVM);
        }

        // POST: SongController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, SongVM song)
        {
            try
            {
                var dbSong = _context.Songs.FirstOrDefault(x => x.Id == id);
                dbSong.Name = song.Name;
                dbSong.Year = song.Year;
                dbSong.GenreId = song.GenreId;

                if (dbSong.DeletedAt.HasValue && song.IsActive)
                {
                    // Song was deleted but now is undeleted
                    dbSong.DeletedAt = null;
                }
                else if (!dbSong.DeletedAt.HasValue && !song.IsActive)
                {
                    // Song wasn't deleted but now is inactive and should be set as deleted
                    dbSong.DeletedAt = DateTime.UtcNow;
                }

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Delete/5
        public ActionResult Delete(int id)
        {
            var song = _context.Songs.Include(x => x.Genre).FirstOrDefault(x => x.Id == id);

            // Map to VM
            var songVM = new SongVM
            {
                Id = song.Id,
                Name = song.Name,
                Year = song.Year,
                GenreName = song.Genre.Name,
                IsActive = !song.DeletedAt.HasValue,
            };

            return View(songVM);
        }

        // POST: SongController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, SongVM song)
        {
            try
            {
                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }
    }
}
