﻿using exercise_10_1.Models;
using exercise_10_1.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

namespace exercise_10_1.Controllers
{
    public class GenreController : Controller
    {
        private readonly Exercise10Context _context;

        public GenreController(Exercise10Context context)
        {
            _context = context;
        }

        // GET: GenreController
        public ActionResult Index()
        {
            try
            {
                var genreVms = _context.Genres.Select(x => new GenreVM {
                    Id = x.Id,
                    Name = x.Name,
                    Description = x.Description,
                }).ToList();

                return View(genreVms);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: GenreController/Details/5
        public ActionResult Details(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                var genreVM = new GenreVM
                {
                    Id = genre.Id,
                    Name = genre.Name,
                    Description = genre.Description,
                };

                return View(genreVM);
            }
            catch (Exception ex)
            {

                throw ex;
            }
        }

        // GET: GenreController/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: GenreController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(GenreVM genre)
        {
            try
            {
                var newGenre = new Genre
                {
                    Name = genre.Name,
                    Description = genre.Description,
                };

                _context.Genres.Add(newGenre);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: GenreController/Edit/5
        public ActionResult Edit(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                var genreVM = new GenreVM
                {
                    Id = genre.Id,
                    Name = genre.Name,
                    Description = genre.Description,
                };

                return View(genreVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: GenreController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, GenreVM genre)
        {
            try
            {
                var dbGenre = _context.Genres.FirstOrDefault(x => x.Id == id);
                dbGenre.Name = genre.Name;
                dbGenre.Description = genre.Description;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: GenreController/Delete/5
        public ActionResult Delete(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                var genreVM = new GenreVM
                {
                    Id = genre.Id,
                    Name = genre.Name,
                    Description = genre.Description,
                };

                return View(genreVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: GenreController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, GenreVM genre)
        {
            try
            {
                var dbGenre = _context.Genres.FirstOrDefault(x => x.Id == id);

                _context.Genres.Remove(dbGenre);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    }
}
