﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace vjezbe_3_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class CollectionController : ControllerBase
    {
        //varijabla stanja kontrolera, koja može držati popis cijelih brojeva
        private static List<int> State { get; set; } = new(); //skraćena inicijalizacija

        //kreiramo novu akciju koja kao parametar uzima polje int
        //akcija dodaje polje int u State
        [HttpPost("[action]")]
        public ActionResult AddToState(int[] numbers)
        {
            try 
            {
                //koristimo izraz .AddRange()
                State.AddRange(numbers);

                //akcija vraća Ok iz metode
                return Ok();
            }
            catch(Exception) { return StatusCode(500); }
        }

        //vraćanje kolekcije iz akcije
        //implementiramo akciju koja vraća stanje kao listu
        [HttpGet("[action]")]
        public ActionResult<List<int>> GetState()
        {
            try
            {
                //koristite asctionResult kao povratni tip
                return Ok(State);
            }
            catch (Exception) { return StatusCode(500); }
        }

        //dodavanje i uklanjanje pojedinih stavki iz kolekcije
        [HttpPost("[action]")]
        public ActionResult AddSingleToState(int number)
        {
            try 
            {
                //akcija za dokavanje broja u listu
                State.Add(number);
                return Ok();
            }
            catch (Exception) { return StatusCode(500); }
        }

        //uklanjanje brojeva iz kolekcije
        [HttpDelete("[action]")]
        public ActionResult RemoveFromState(int number)
        {
            try 
            {
                State.RemoveAll(n=>n==number);
                return Ok();
            }
            catch (Exception) { return StatusCode(500); }
        }

    }
}
