﻿using Microsoft.AspNetCore.Mvc;
using vjezbe_3_4.Models;
using vjezbe_3_4.Repository;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace vjezbe_3_4.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class AddressController : ControllerBase
    {
        ////implementiramo popis ulica kao statička varijabla
        //private static List<Street> Streets = new List<Street>
        //{
        //    new Street{Id=1, Name="Ilica"},
        //    new Street{Id=2, Name="Maksimirska" }
        //};


        ////vraća popis ulica
        //// GET: api/<AddressController>
        //[HttpGet]
        //public ActionResult<IEnumerable<Street>> Get()
        //{
        //    return Ok(Streets);
        //}

        ////vraćanje ulica prema identifikatoru
        //// GET api/<AddressController>/5
        //[HttpGet("{id}")]
        //public ActionResult<IEnumerable<Street>> Get(int id)
        //{
        //    var street=Streets.First(x=>x.Id==id);
        //    if (street == null)
        //        return NotFound();
        //    return Ok(street);
        //}

        //// POST api/<AddressController>
        //[HttpPost]
        //public ActionResult<Street> Post([FromBody]Street street) 
        //{
        //    if (street == null)
        //        return BadRequest();

        //    //izračun sljedećeg identifikatora
        //    street.Id = Streets.Max(x=>x.Id)+1;
        //    Streets.Add(street);
        //    return CreatedAtAction(nameof(Get), new {id=street.Id},street);
        //}

        //// PUT api/<AddressController>/5
        //[HttpPut("{id}")]
        //public ActionResult<Street> Put(int id,  [FromBody]Street street) 
        //{
        //    var existingStreet=Streets.FirstOrDefault(x=>x.Id == id);
        //    if (existingStreet == null)
        //        return NotFound();
        //    existingStreet.Name= street.Name;
        //    return Ok(existingStreet);
        //}

        //// DELETE api/<AddressController>/5
        //[HttpDelete("{id}")]
        //public ActionResult<Street> Delete(int id) 
        //{
        //    var street=Streets.FirstOrDefault(x=>x.Id== id);
        //    if (street == null) return NotFound();
        //    Streets.Remove(street);
        //    return Ok(street);
        //}




        //vraća popis ulica
        // GET: api/<AddressController>
        [HttpGet]
        public ActionResult<IEnumerable<Street>> Get()
        {
            try {
                return Ok(AddressRepository.Streets);
            }
            catch(Exception) {
                return StatusCode(500);
            }
        }

        //vraćanje ulica prema identifikatoru
        // GET api/<AddressController>/5
        [HttpGet("{id}")]
        public ActionResult<IEnumerable<Street>> Get(int id)
        {
            try {
                var street=AddressRepository.Streets.FirstOrDefault(x => x.Id == id);
                if(street == null) {return NotFound();}
                return Ok(street);
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        // POST api/<AddressController>
        [HttpPost]
        public ActionResult<Street> Post([FromBody] Street street)
        {
            try {
                if (String.IsNullOrEmpty(street.Name)) return BadRequest("Name is empty!");

                int maxId = AddressRepository.Streets.Any() ? AddressRepository.Streets.Max(x => x.Id) : 0;
                street.Id = maxId+1;

                AddressRepository.Streets.Add(street);
                var location=Url.Action(nameof(Get), new {id=street.Id});
                return Created(location, street);
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        // PUT api/<AddressController>/5
        [HttpPut("{id}")]
        public ActionResult<Street> Put(int id, [FromBody] Street street)
        {
            var existingStreet = Streets.FirstOrDefault(x => x.Id == id);
            if (existingStreet == null)
                return NotFound();
            existingStreet.Name = street.Name;
            return Ok(existingStreet);
        }

        // DELETE api/<AddressController>/5
        [HttpDelete("{id}")]
        public ActionResult<Street> Delete(int id)
        {
            var street = Streets.FirstOrDefault(x => x.Id == id);
            if (street == null) return NotFound();
            Streets.Remove(street);
            return Ok(street);
        }
    }
}
