﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;

namespace exercise_4_1.Models;

public partial class Exercise4Context : DbContext
{
    public Exercise4Context()
    {
    }

    public Exercise4Context(DbContextOptions<Exercise4Context> options)
        : base(options)
    {
    }

    public virtual DbSet<Notification> Notifications { get; set; }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        => optionsBuilder.UseSqlServer("name=ConnectionStrings:Exercise4ConnStr");

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder.Entity<Notification>(entity =>
        {
            entity.ToTable("Notification");

            entity.Property(e => e.Body).HasMaxLength(2048);
            entity.Property(e => e.CreatedAt).HasDefaultValueSql("(getutcdate())");
            entity.Property(e => e.Guid).HasDefaultValueSql("(newid())");
            entity.Property(e => e.Receiver).HasMaxLength(256);
            entity.Property(e => e.Subject).HasMaxLength(256);
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
