﻿using exercise_07.Dtos;
using exercise_07.Models;

namespace exercise_07.Mapping
{
    public class AudioMapping
    {
        public static IEnumerable<AudioDto> MapToBL(IEnumerable<Audio> audios) =>
            audios.Select(x => MapToBL(x));

        public static AudioDto MapToBL(Audio audio) =>
            new AudioDto
            {
                Id = audio.Id,
                Title = audio.Title,
                GenreId = audio.GenreId,
                Duration = audio.Duration,
                Url = audio.Url,
                Tags = audio.AudioTags.Select(x => x.Tag.Name).ToList(),
            };

        public static IEnumerable<Audio> MapToDAL(IEnumerable<AudioDto> blAudios) =>
            blAudios.Select(x => MapToDAL(x));

        public static Audio MapToDAL(AudioDto audio) =>
            new Audio
            {
                Id = audio.Id ?? 0,
                Title = audio.Title,
                GenreId = audio.GenreId,
                Duration = audio.Duration,
                Url = audio.Url,
            };
    }
}
