﻿using exercise_10_1.Models;
using exercise_10_1.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;

namespace exercise_10_1.Controllers
{
    public class SongController : Controller
    {
        private readonly Exercise10Context _context;

        public SongController(Exercise10Context context)
        {
            _context = context;
        }

        // GET: SongController
        public ActionResult Index()
        {
            try
            {
                var songVms = _context.Songs
                    .Include(x => x.Genre)
                    .Include(x => x.Artist)
                    .Select(x => new SongVM
                        {
                            Id = x.Id,
                            Name = x.Name,
                            Year = x.Year ?? 0,
                            ArtistId = x.ArtistId,
                            ArtistName = x.Artist.Name,
                            GenreId = x.GenreId,
                            GenreName = x.Genre.Name,
                    })
                    .ToList();

                return View(songVms);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: SongController/Details/5
        public ActionResult Details(int id)
        {
            return View();
        }

        // GET: SongController/Create
        public ActionResult Create()
        {
            try
            {
                ViewBag.GenreDdlItems = _context.Genres
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    });

                ViewBag.ArtistDdlItems = _context.Artists
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    });

                return View();
            }
            catch (Exception)
            {

                throw;
            }
        }

        // POST: SongController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(SongVM song)
        {
            try
            {
                if (!ModelState.IsValid) 
                {
                    ViewBag.GenreDdlItems = _context.Genres
                        .Select(x => new SelectListItem
                        {
                            Text = x.Name,
                            Value = x.Id.ToString()
                        });

                    ViewBag.ArtistDdlItems = _context.Artists
                        .Select(x => new SelectListItem
                        {
                            Text = x.Name,
                            Value = x.Id.ToString()
                        });

                    ModelState.AddModelError("", "Failed to create song");

                    return View();
                }

                var newSong = new Song
                {
                    Name = song.Name,
                    Year = song.Year,
                    GenreId = song.GenreId,
                    ArtistId = song.ArtistId,
                };

                _context.Songs.Add(newSong);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Edit/5
        public ActionResult Edit(int id)
        {
            ViewBag.GenreDdlItems = _context.Genres
                .Select(x => new SelectListItem
                {
                    Text = x.Name,
                    Value = x.Id.ToString()
                });

            ViewBag.ArtistDdlItems = _context.Artists
                .Select(x => new SelectListItem
                {
                    Text = x.Name,
                    Value = x.Id.ToString()
                });

            var song = _context.Songs.FirstOrDefault(x => x.Id == id);
            var songVM = new SongVM
            {
                Id = song.Id,
                Name = song.Name,
                Year = song.Year.Value,
                GenreId = song.GenreId,
                ArtistId = song.ArtistId,
            };

            return View(songVM);
        }

        // POST: SongController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, SongVM song)
        {
            try
            {
                var dbSong = _context.Songs.FirstOrDefault(x => x.Id == id);
                dbSong.Name = song.Name;
                dbSong.Year = song.Year;
                dbSong.GenreId = song.GenreId;
                dbSong.ArtistId = song.ArtistId;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Delete/5
        public ActionResult Delete(int id)
        {
            return View();
        }

        // POST: SongController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, IFormCollection collection)
        {
            try
            {
                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }
    }
}
