﻿using exercise_11_1.Models;
using exercise_11_1.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;

namespace exercise_11_1.Controllers
{
    public class SongController : Controller
    {
        private readonly Exercise11Context _context;

        public SongController(Exercise11Context context)
        {
            _context = context;
        }

        // GET: SongController
        public ActionResult Index()
        {
            try
            {
                var songVms = _context.Audios
                    .Include(x => x.Genre)
                    .Include(x => x.Artist)
                    .Select(x => new SongVM
                        {
                            Id = x.Id,
                            Title = x.Title,
                            Year = x.Year,
                            ArtistId = x.ArtistId,
                            ArtistName = x.Artist.Name,
                            GenreId = x.GenreId,
                            GenreName = x.Genre.Name,
                            Duration = x.Duration,
                            Url = x.Url
                    })
                    .ToList();

                return View(songVms);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: SongController/Details/5
        public ActionResult Details(int id)
        {
            return View();
        }

        // GET: SongController/Create
        public ActionResult Create()
        {
            try
            {
                ViewBag.GenreDdlItems = _context.Genres
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    });

                ViewBag.ArtistDdlItems = _context.Artists
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    });

                return View();
            }
            catch (Exception)
            {

                throw;
            }
        }

        // POST: SongController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(SongVM song)
        {
            try
            {
                if (!ModelState.IsValid) 
                {
                    ViewBag.GenreDdlItems = _context.Genres
                        .Select(x => new SelectListItem
                        {
                            Text = x.Name,
                            Value = x.Id.ToString()
                        });

                    ViewBag.ArtistDdlItems = _context.Artists
                        .Select(x => new SelectListItem
                        {
                            Text = x.Name,
                            Value = x.Id.ToString()
                        });

                    ModelState.AddModelError("", "Failed to create song");

                    return View();
                }

                var newSong = new Audio
                {
                    Title = song.Title,
                    Year = song.Year,
                    GenreId = song.GenreId,
                    ArtistId = song.ArtistId,
                    Duration = song.Duration,
                    Url = song.Url
                };

                _context.Audios.Add(newSong);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Edit/5
        public ActionResult Edit(int id)
        {
            ViewBag.GenreDdlItems = _context.Genres
                .Select(x => new SelectListItem
                {
                    Text = x.Name,
                    Value = x.Id.ToString()
                });

            ViewBag.ArtistDdlItems = _context.Artists
                .Select(x => new SelectListItem
                {
                    Text = x.Name,
                    Value = x.Id.ToString()
                });

            var song = _context.Audios.FirstOrDefault(x => x.Id == id);
            var songVM = new SongVM
            {
                Id = song.Id,
                Title = song.Title,
                Year = song.Year,
                GenreId = song.GenreId,
                ArtistId = song.ArtistId,
                Duration = song.Duration,
                Url = song.Url
            };

            return View(songVM);
        }

        // POST: SongController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, SongVM song)
        {
            try
            {
                var dbSong = _context.Audios.FirstOrDefault(x => x.Id == id);
                dbSong.Title = song.Title;
                dbSong.Year = song.Year;
                dbSong.GenreId = song.GenreId;
                dbSong.ArtistId = song.ArtistId;
                dbSong.Duration = song.Duration;
                dbSong.Url = song.Url;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: SongController/Delete/5
        public ActionResult Delete(int id)
        {
            var song = _context.Audios
                .Include(x => x.Artist)
                .Include(x => x.Genre)
                .FirstOrDefault(x => x.Id == id);
            var songVM = new SongVM
            {
                Id = song.Id,
                Title = song.Title,
                Year = song.Year,
                GenreId = song.GenreId,
                GenreName = song.Genre.Name,
                ArtistId = song.ArtistId,
                ArtistName = song.Artist.Name,
                Duration = song.Duration,
                Url = song.Url
            };

            return View(songVM);
        }

        // POST: SongController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, Audio audio)
        {
            try
            {
                var dbAudio = _context.Audios.FirstOrDefault(x => x.Id == id);

                _context.Audios.Remove(dbAudio);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    }
}
