﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;

namespace exercise_13.Models;

public partial class Exercise13Context : DbContext
{
    public Exercise13Context()
    {
    }

    public Exercise13Context(DbContextOptions<Exercise13Context> options)
        : base(options)
    {
    }

    public virtual DbSet<Artist> Artists { get; set; }

    public virtual DbSet<Audio> Audios { get; set; }

    public virtual DbSet<AudioTag> AudioTags { get; set; }

    public virtual DbSet<Genre> Genres { get; set; }

    public virtual DbSet<Tag> Tags { get; set; }

    public virtual DbSet<User> Users { get; set; }

    public virtual DbSet<UserAudioPermission> UserAudioPermissions { get; set; }

    public virtual DbSet<UserRole> UserRoles { get; set; }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        => optionsBuilder.UseSqlServer("Name=ConnectionStrings:ex13cs");

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder.Entity<Artist>(entity =>
        {
            entity.ToTable("Artist");

            entity.Property(e => e.Name).HasMaxLength(256);
        });

        modelBuilder.Entity<Audio>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Audio__3214EC072AFFAF4D");

            entity.ToTable("Audio");

            entity.Property(e => e.Title).HasMaxLength(256);
            entity.Property(e => e.Url).HasMaxLength(256);

            entity.HasOne(d => d.Artist).WithMany(p => p.Audios)
                .HasForeignKey(d => d.ArtistId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Audio_Artist");

            entity.HasOne(d => d.Genre).WithMany(p => p.Audios)
                .HasForeignKey(d => d.GenreId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Audio_Genre");
        });

        modelBuilder.Entity<AudioTag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__AudioTag__3214EC078C46392C");

            entity.ToTable("AudioTag");

            entity.HasOne(d => d.Audio).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.AudioId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Audio");

            entity.HasOne(d => d.Tag).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.TagId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Tag");
        });

        modelBuilder.Entity<Genre>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Genre__3214EC071AB4F1D3");

            entity.ToTable("Genre");

            entity.Property(e => e.Name).HasMaxLength(256);
        });

        modelBuilder.Entity<Tag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Tag__3214EC07E0BA62A5");

            entity.ToTable("Tag");

            entity.Property(e => e.Name).HasMaxLength(10);
        });

        modelBuilder.Entity<User>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK_User");

            entity.ToTable("USER");

            entity.Property(e => e.Email).HasMaxLength(256);
            entity.Property(e => e.FirstName).HasMaxLength(256);
            entity.Property(e => e.LastName).HasMaxLength(256);
            entity.Property(e => e.Phone).HasMaxLength(256);
            entity.Property(e => e.PwdHash).HasMaxLength(256);
            entity.Property(e => e.PwdSalt).HasMaxLength(256);
            entity.Property(e => e.Username).HasMaxLength(50);

            entity.HasOne(d => d.Role).WithMany(p => p.Users)
                .HasForeignKey(d => d.RoleId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_USER_UserRole");
        });

        modelBuilder.Entity<UserAudioPermission>(entity =>
        {
            entity.ToTable("UserAudioPermission");

            entity.Property(e => e.Id).ValueGeneratedNever();

            entity.HasOne(d => d.Audio).WithMany(p => p.UserAudioPermissions)
                .HasForeignKey(d => d.AudioId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_UserAudioPermission_Audio");

            entity.HasOne(d => d.User).WithMany(p => p.UserAudioPermissions)
                .HasForeignKey(d => d.UserId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_UserAudioPermission_User");
        });

        modelBuilder.Entity<UserRole>(entity =>
        {
            entity.ToTable("UserRole");

            entity.Property(e => e.Name).HasMaxLength(50);
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
