﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;

namespace exercise_07.Models;

public partial class Exercise72Ip1Context : DbContext
{
    public Exercise72Ip1Context()
    {
    }

    public Exercise72Ip1Context(DbContextOptions<Exercise72Ip1Context> options)
        : base(options)
    {
    }

    public virtual DbSet<Audio> Audios { get; set; }

    public virtual DbSet<AudioTag> AudioTags { get; set; }

    public virtual DbSet<Genre> Genres { get; set; }

    public virtual DbSet<Tag> Tags { get; set; }

    public virtual DbSet<User> Users { get; set; }

    public virtual DbSet<UserAudioPermission> UserAudioPermissions { get; set; }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        => optionsBuilder.UseSqlServer("Name=ConnectionStrings:AppConnStr");

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder.Entity<Audio>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Audio__3214EC0760F2852D");

            entity.ToTable("Audio");

            entity.Property(e => e.Title).HasMaxLength(256);
            entity.Property(e => e.Url).HasMaxLength(256);

            entity.HasOne(d => d.Genre).WithMany(p => p.Audios)
                .HasForeignKey(d => d.GenreId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Audio_Genre");
        });

        modelBuilder.Entity<AudioTag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__AudioTag__3214EC073E36F5C0");

            entity.ToTable("AudioTag");

            entity.HasOne(d => d.Audio).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.AudioId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Audio");

            entity.HasOne(d => d.Tag).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.TagId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Tag");
        });

        modelBuilder.Entity<Genre>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Genre__3214EC0760E8E921");

            entity.ToTable("Genre");

            entity.Property(e => e.Name).HasMaxLength(256);
        });

        modelBuilder.Entity<Tag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Tag__3214EC0746850931");

            entity.ToTable("Tag");

            entity.Property(e => e.Name).HasMaxLength(10);
        });

        modelBuilder.Entity<User>(entity =>
        {
            entity.ToTable("User");

            entity.Property(e => e.Email).HasMaxLength(256);
            entity.Property(e => e.FirstName).HasMaxLength(256);
            entity.Property(e => e.LastName).HasMaxLength(256);
            entity.Property(e => e.Phone).HasMaxLength(256);
            entity.Property(e => e.PwdHash).HasMaxLength(256);
            entity.Property(e => e.PwdSalt).HasMaxLength(256);
            entity.Property(e => e.Username).HasMaxLength(50);
        });

        modelBuilder.Entity<UserAudioPermission>(entity =>
        {
            entity.ToTable("UserAudioPermission");

            entity.Property(e => e.Id).ValueGeneratedNever();

            entity.HasOne(d => d.Audio).WithMany(p => p.UserAudioPermissions)
                .HasForeignKey(d => d.AudioId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_UserAudioPermission_Audio");

            entity.HasOne(d => d.User).WithMany(p => p.UserAudioPermissions)
                .HasForeignKey(d => d.UserId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_UserAudioPermission_User");
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
