﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace vjezbe_3_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class CollectionController : ControllerBase
    {
        //varijabla stanja kontroleru koja može držati popis cijelih brojeva
        private static List<int> State { get; set; } = new(); //skraćenje inicijalizacije za tip new()

        [HttpPost("[action]")]
        public ActionResult AddToState(int[] numbers)
        {
            try {
                State.AddRange(numbers);
                return Ok();
            }
            catch (Exception) { return StatusCode(500); }
        }

        //implentacija akcije koja vraća stanje kao listu
        [HttpGet("[action]")]
        public ActionResult<List<int>> GetState()
        {
            try {
                //povratin tip je ActionResult<List<int>>
                return Ok(State);
            }
            catch (Exception) { return StatusCode(500,"Error");}
        }


        //dodavanje pojedinih stavki u kolekciju
        [HttpPost("[action]")]
        public ActionResult AddSingleToState(int number)
        {
            try {
                //napravimpo akciju koja dodaje broj u listu
                State.Add(number);
                return Ok();
            }
            catch (Exception) { return StatusCode(500, "Error"); }
        }

        //akcija uklanjanja brojeva iz liste
        [HttpDelete("[action]")]
        public ActionResult RemoveFromState(int number)
        {
            try {
                State.RemoveAll(n=>n==number);
                return Ok();
            }
            catch (Exception) { return StatusCode(500, "Error"); }
        }
    }
}
