﻿using exercise_4_1.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Http.HttpResults;
using Microsoft.AspNetCore.Mvc;

namespace exercise_4_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class NotificationsController : ControllerBase
    {
        private readonly Exercise4Context _context;
        public NotificationsController(Exercise4Context context)
        {
            _context = context;
        }

        [HttpGet]
        public ActionResult<List<Notification>> GetAllNotifications(int start=0, int count=10)
        {
            //Exercise4Context context = new Exercise4Context();
            //nećemo više koristi gornji način, nego korsitimo depdency injection servis
            //koji se prosljeđuje prilikom instanciranja klase NotificationController
            try
            {
                return Ok(_context.Notifications.Skip(start*count).Take(count));
            }
            catch(Exception ex) { return StatusCode(500, ex.Message); }
            
        }
    }
}
