﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace exercise_4_1.Models;

[Table("Notification")]
public partial class Notification
{
    [Key]
    public int Id { get; set; }

    public Guid Guid { get; set; }

    public DateTime CreatedAt { get; set; }

    [StringLength(256)]
    public string Receiver { get; set; } = null!;

    [StringLength(256)]
    public string? Subject { get; set; }

    [StringLength(2048)]
    public string Body { get; set; } = null!;

    public DateTime? SentAt { get; set; }

    public int? Priority { get; set; }
}
