﻿using Microsoft.AspNetCore.Mvc;
using vjezbe_3_4.Models;
using vjezbe_3_4.Repository;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace vjezbe_3_4.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class AdressController : ControllerBase
    {
        ////statička varijabla s popisom ulica
        //private static List<Street> Streets = new List<Street>
        //{ 
        //    new Street {Id=1, Name="Ilica"},
        //    new Street{ Id=2, Name="Gradišćanska"}
        //};

        //// GET: api/<AdressController>
        //[HttpGet]
        //public ActionResult<IEnumerable<Street>> Get()
        //{
        //    return Ok(Streets);
        //}

        //// GET api/<AdressController>/5
        //[HttpGet("{id}")]
        //public ActionResult<Street> Get(int id)
        //{
        //    try
        //    {
        //        var street = Streets.First(x => x.Id == id);
        //        if(street == null) return NotFound();
        //        return Ok(street);
        //    }
        //    catch (Exception) { return BadRequest("No that streeet"); }
        //}

        //// POST api/<AdressController>
        //[HttpPost]
        //public ActionResult<Street> Post([FromBody] Street street)
        //{
        //    if (street == null) return BadRequest();

        //    //izračunati sljedeći identifikator
        //    street.Id=Streets.Max(x => x.Id)+1;
        //    Streets.Add(street);
        //    return CreatedAtAction(nameof(Get), new {id=street.Id},street);

        //}

        //// PUT api/<AdressController>/5
        //[HttpPut("{id}")]
        //public ActionResult<Street> Put(int id, [FromBody] Street street)
        //{
        //    var existingStreet=Streets.FirstOrDefault(x => x.Id == id);
        //    if (existingStreet == null) return NotFound();

        //    existingStreet.Name=street.Name;
        //    return Ok(existingStreet);

        //}

        //// DELETE api/<AdressController>/5
        //[HttpDelete("{id}")]
        //public ActionResult<Street> Delete(int id)
        //{

        //    var street=Streets.FirstOrDefault(x=>x.Id == id);
        //    if (street == null) return NotFound();

        //    Streets.Remove(street);
        //    return NoContent();
        //}


        // GET: api/<AdressController>
        [HttpGet]
        public ActionResult<IEnumerable<Street>> Get()
        {
            try 
            {
                return Ok(AdressRepository.Streets);
            }
            catch (Exception) { return StatusCode(500, "There is a porblem with retrieving streets"); }
        }

        // GET api/<AdressController>/5
        [HttpGet("{id}")]
        public ActionResult<Street> Get(int id)
        {
            try
            {
                var street = AdressRepository.Streets.FirstOrDefault(x => x.Id == id);
                if (street == null) return NotFound();
                return Ok(street);
            }
            catch (Exception) { return BadRequest("No that streeet"); }
        }

        // POST api/<AdressController>
        [HttpPost]
        public ActionResult<Street> Post([FromBody] Street street)
        {
            if (String.IsNullOrEmpty(street.Name)) return BadRequest();

            int maxId = AdressRepository.Streets.Any() ? AdressRepository.Streets.Max(x => x.Id) : 0;
            street.Id = maxId;
            AdressRepository.Streets.Add(street);

            var location=Url.Action(nameof(Get), new  { id=street.Id});
            return Created(location, street);

           

        }

        // PUT api/<AdressController>/5
        [HttpPut("{id}")]
        public ActionResult<Street> Put(int id, [FromBody] Street street)
        {
            var existingStreet= AdressRepository.Streets.FirstOrDefault(x=>x.Id== id);
            if(existingStreet == null) return NotFound();
            existingStreet.Name=street.Name;
            return Ok(existingStreet);

        }

        // DELETE api/<AdressController>/5
        [HttpDelete("{id}")]
        public ActionResult<Street> Delete(int id)
        {

            var exitingStreet=AdressRepository.Streets.FirstOrDefault(x=>x.Id == id);
            if (exitingStreet == null) return NotFound();
            AdressRepository.Streets.Remove(exitingStreet);
            return Ok(exitingStreet);
        }
    }
}
