﻿using excercise_06.Security;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace excercise_06.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class UserController : ControllerBase
    {
        private readonly IConfiguration _configuration;
        public UserController(IConfiguration configuration)
        {
            _configuration = configuration;
        }

        [HttpGet]
        public ActionResult<string> GetToken()
        {
            try
            {
                var secureKey = _configuration["JwT:SecureKey"];
                var token = JwTokenProvider.CreateToken(secureKey, 10);
                return Ok(token);
            }
            catch (Exception)
            { return StatusCode(500); }
        }
    }
}
