﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using vjezbe_6_1.Security;
using vjezbe_6_1.DTOs;
using vjezbe_6_1.Models;

namespace vjezbe_6_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class UserController : ControllerBase
    {
        private readonly IConfiguration _configuration;
        private readonly Exercise06Context _context;
        public UserController(IConfiguration configuration, Exercise06Context context)
        {
            this._configuration = configuration;
            this._context = context;
        }


        [HttpPost]
        public ActionResult<UserDto> Register([FromBody] UserDto userDto)
        {
            //procitati reg body
            //instancirati i spremiti instancu
            //usera u bazu podataka 
            //vratiti 201 ili 200

            var username = userDto.Username.Trim();
            if (_context.Users.Any(x => x.Username == username) == true)
            {
                return BadRequest("Username already taken!");
            }

            //create salt and hash
            var salt = PasswordHashProvider.GetSalt();
            var passwordHash = PasswordHashProvider.GetHash(userDto.Password, salt);

            //create new instance of User and add it to database
            User user = new()
            {
                Username = username,
                PwdHash = passwordHash,
                PwdSalt = salt,
                FirstName = userDto.FirstName,
                LastName = userDto.LastName,
                Phone = userDto.Phone,
                Email = userDto.Email
            };

            _context.Users.Add(user);//state of this object in change tacker is created ->
            //insert into Users values()
            _context.SaveChanges();
            userDto.Id = user.Id; //reading the values of ID generated by identity

            return Ok(userDto);
        }

        [HttpPost("login")]
        public ActionResult Login([FromBody] UserLoginDto userLoginDto)
        {
            var genericErrorMessage = "Incorrect username or password";

            if (ModelState.IsValid == false) return BadRequest(ModelState);

            var username = userLoginDto.Username.Trim();
            if (_context.Users.Any(u => u.Username == username) == false)
                return BadRequest(genericErrorMessage);

            return Ok();
        }


        [HttpGet]
        public ActionResult<string> GetToken()
        {
            try {
                var secureKey = _configuration["Jwt:SecureKey"];
                var token = JwTokenProvider.CreateToken(secureKey, 10);
                return Ok(token);
            }
            catch (Exception) { return StatusCode(500); }
        }
    }
}
