﻿using Task07.Models;

namespace Task07.Mapping
{
    public class AudioMapping
    {
        public static IEnumerable<BLAudio> MapToBL(IEnumerable<Audio> audios) =>
            audios.Select(x => MapToBL(x));

        public static BLAudio MapToBL(Audio audio) =>
            new BLAudio
            {
                Id = audio.Id,
                Title = audio.Title,
                GenreId = audio.GenreId,
                Duration = audio.Duration,
                Url = audio.Url,
                Tags = audio.AudioTags.Select(x => x.Tag.Name).ToList(),
            };

        public static IEnumerable<Audio> MapToDAL(IEnumerable<BLAudio> blAudios) =>
            blAudios.Select(x => MapToDAL(x));

        public static Audio MapToDAL(BLAudio audio) =>
            new Audio
            {
                Id = audio.Id ?? 0,
                Title = audio.Title,
                GenreId = audio.GenreId,
                Duration = audio.Duration,
                Url = audio.Url,
            };
    }
}
