﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;

namespace Task07.Models;

public partial class Task07Context : DbContext
{
    public Task07Context()
    {
    }

    public Task07Context(DbContextOptions<Task07Context> options)
        : base(options)
    {
    }

    public virtual DbSet<Audio> Audios { get; set; }

    public virtual DbSet<AudioTag> AudioTags { get; set; }

    public virtual DbSet<Genre> Genres { get; set; }

    public virtual DbSet<Tag> Tags { get; set; }

    protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        => optionsBuilder.UseSqlServer("Name=ConnectionStrings:AudioConnStr");

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder.Entity<Audio>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Audio__3214EC0724A2924C");

            entity.ToTable("Audio");

            entity.Property(e => e.Title).HasMaxLength(256);
            entity.Property(e => e.Url).HasMaxLength(256);

            entity.HasOne(d => d.Genre).WithMany(p => p.Audios)
                .HasForeignKey(d => d.GenreId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_Audio_Genre");
        });

        modelBuilder.Entity<AudioTag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__AudioTag__3214EC07DA470B5C");

            entity.ToTable("AudioTag");

            entity.HasOne(d => d.Audio).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.AudioId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Audio");

            entity.HasOne(d => d.Tag).WithMany(p => p.AudioTags)
                .HasForeignKey(d => d.TagId)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("FK_AudioTag_Tag");
        });

        modelBuilder.Entity<Genre>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Genre__3214EC07239E5BA7");

            entity.ToTable("Genre");

            entity.Property(e => e.Name).HasMaxLength(256);
        });

        modelBuilder.Entity<Tag>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("PK__Tag__3214EC070D1B3E8A");

            entity.ToTable("Tag");

            entity.Property(e => e.Name).HasMaxLength(10);
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
