﻿const allGenresUrl = "http://localhost:5127/api/Genre/GetAll";
const allAudiosUrl = "http://localhost:5127/api/Audio/GetAll";
const searchAudiosUrl = "http://localhost:5127/api/Audio/Search";
const audioUrl = "http://localhost:5127/api/Audio";

function jwtLogout() {
    localStorage.removeItem("JWT");

    // redirect
    window.location.href = "login.html";
}

function fillAllAudiosData() {
    let jwt = localStorage.getItem("JWT");

    $.ajax({
        url: allAudiosUrl,
        headers: { "Authorization": `Bearer ${jwt}` }
    }).done(function (allAudioData) {
        renderAudioCards(allAudioData);
    }).fail(function () {
        console.error("There was an error while trying to load your data");
    });
}

function renderAudioCards(cards) {
    const $ph = $("#placeholder");

    for (let card of cards) {
        const html = `<div class="col-sm-4"><div class="card" data-id="${card.id}">
            <div class="card-header">${card.title}</div>
            <div class="card-body">
                <p class="card-text">Duration: ${card.duration} seconds</p>
                <a href="${card.url}" class="btn btn-primary">Play</a>
                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop" data-id="${card.id}" data-operation="edit">Edit</button>
                <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#staticBackdrop" data-id="${card.id}" data-operation="delete">Delete</button>
            </div>
        </div></div>`;

        $ph.append(html);
    }
}

function fillGenresData() {
    let jwt = localStorage.getItem("JWT");

    $.ajax({
        url: allGenresUrl,
        headers: { "Authorization": `Bearer ${jwt}` }
    }).done(function (allGenresData) {
        renderGenres(allGenresData);
    }).fail(function () {
        console.error("There was an error while trying to load your data");
    });
}

function renderGenres(genres) {
    const $genreSelect = $("#genreId");

    for (let genre of genres) {
        const html = `<option value="${genre.id}">${genre.name}</option>`;

        $genreSelect.append(html);
    }
}

function search() {
    $("#search-spinner-placeholder").addClass("spinner");
    $("#search").prop("disabled", true);

    const searchTerm = $("#searchTerm").val();
    const jwt = localStorage.getItem("JWT");

    $.ajax({
        url: searchTerm ? searchAudiosUrl : allAudiosUrl,
        data: {
            "searchPart": searchTerm
        },
        headers: { "Authorization": `Bearer ${jwt}` }
    }).done((allAudioData) => {
        $("#placeholder").html("");

        $("#search-spinner-placeholder").removeClass("spinner");
        $("#search-button").prop("disabled", false);

        renderAudioCards(allAudioData);
    })
}

function confirmAudio() {
    $("#ok-spinner-placeholder").addClass("spinner");
    $("#ok-button").prop("disabled", true);

    const id = $("#id").val();
    const operation = $("#operation").val(); // add, edit or delete
    const title = $("#title").val();
    const genreId = $("#genreId").val();
    const duration = $("#duration").val();
    const url = $("#url").val();
    const jwt = localStorage.getItem("JWT");

    let audioData = {
        "title": title,
        "genreId": genreId,
        "duration": duration,
        "url": url,
        "tags": []
    };

    let method;
    if (operation == "add") {
        method = "POST";
    } else if (operation == "edit") {
        method = "PUT";
        audioData["id"] = id;
    } else {
        method = "DELETE";
        audioData["id"] = id;
    }

    $.ajax({
        method: method,
        url: operation != "add" ? `${audioUrl}/${id}` : audioUrl,
        data: operation != "delete" ? JSON.stringify(audioData) : null,
        contentType: 'application/json',
        headers: { "Authorization": `Bearer ${jwt}` }
    }).done(() => {
        $("#ok-spinner-placeholder").removeClass("spinner");
        $("#ok-button").prop("disabled", false);

        // Close the modal (inobtrusive Bootstrap way of closing the modal)
        $("[data-bs-dismiss=modal]").trigger({ type: "click" });

        // Reset search
        $("#search-button").trigger({ type: "click" });
    }).fail((err) => {
        alert(err.responseText);

        $("#ok-spinner-placeholder").removeClass("spinner");
        $("#ok-button").prop("disabled", false);
    })
}

function setAudioForm(id, operation) {
    $("#operation").val(operation); // add, edit or delete

    if (operation == "add")
        return; // No reason to retrieve any data

    $("#ok-spinner-placeholder").addClass("spinner");
    $("#ok-button").prop("disabled", true);

    const jwt = localStorage.getItem("JWT");

    $.ajax({
        url: `${audioUrl}/${id}`,
        headers: { "Authorization": `Bearer ${jwt}` }
    }).done((data) => {
        $("#ok-spinner-placeholder").removeClass("spinner");
        $("#ok-button").prop("disabled", false);

        $("#id").val(data.id);
        $("#title").val(data.title);
        $("#genreId").val(data.genreId);
        $("#duration").val(data.duration);
        $("#url").val(data.url);

    }).fail((err) => {
        alert(err.responseText);

        $("#ok-spinner-placeholder").removeClass("spinner");
        $("#ok-button").prop("disabled", false);
    })
}

function onModalShow(event) {
    var $clickedBtn = $(event.relatedTarget);

    var operation = $clickedBtn.data('operation'); // add, edit or delete
    var id = $clickedBtn.data('id');

    if (operation == "add") {
        setAudioForm(id, operation);
        $("#staticBackdrop :input").prop("disabled", false);
    } else if (operation == "edit") {
        setAudioForm(id, operation);
        $("#staticBackdrop :input").prop("disabled", false);
    } else if (operation == "delete") {
        setAudioForm(id, operation);
        $("#staticBackdrop input").prop("disabled", true);
        $("#staticBackdrop select").prop("disabled", true);
    }
}

function onModalHide(event) {
    $("#staticBackdrop :input").prop("disabled", false);
    $("#staticBackdrop :input").val("");
}

$(function () {
    let jwt = localStorage.getItem("JWT");
    if (!jwt) {
        window.location.href = "login.html";
    }

    fillAllAudiosData();
    fillGenresData();

    // Intercept modal show/hide event
    var modal = document.getElementById('staticBackdrop');
    modal.addEventListener('show.bs.modal', onModalShow);
    modal.addEventListener('hide.bs.modal', onModalHide);
});
