﻿using AutoMapper;
using ex13.BL.Models;
using exercise_13.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using NuGet.Protocol;

namespace exercise_13.Controllers
{
    [Authorize]
    public class GenreController : Controller
    {
        private readonly Exercise13Context _context;
        private readonly IMapper _mapper;

        public GenreController(Exercise13Context context, IMapper mapper)
        {
            _context = context;
            _mapper = mapper;
        }

        // GET: GenreController
        public ActionResult Index()
        {
            try
            {
                if (TempData.ContainsKey("newGenre"))
                {
                    var newGenre = ((string)TempData["newGenre"]).FromJson<GenreVM>();
                }

                //var genreVms = _context.Genres.Select(x => new GenreVM {
                //    Id = x.Id,
                //    Name = x.Name,
                //}).ToList();
                var genreVms = _mapper.Map<IEnumerable<GenreVM>>(_context.Genres);

                return View(genreVms);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: GenreController/Details/5
        public ActionResult Details(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                //var genreVM = new GenreVM
                //{
                //    Id = genre.Id,
                //    Name = genre.Name,
                //};
                var genreVM = _mapper.Map<GenreVM>(genre);

                return View(genreVM);
            }
            catch (Exception ex)
            {

                throw ex;
            }
        }

        // GET: GenreController/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: GenreController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(GenreVM genre)
        {
            try
            {
                var newGenre = new Genre
                {
                    Name = genre.Name,
                };

                _context.Genres.Add(newGenre);

                _context.SaveChanges();

                TempData["newGenre"] = newGenre.ToJson();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: GenreController/Edit/5
        public ActionResult Edit(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                //var genreVM = new GenreVM
                //{
                //    Id = genre.Id,
                //    Name = genre.Name,
                //};
                var genreVM = _mapper.Map<GenreVM>(genre);

                return View(genreVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: GenreController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, GenreVM genre)
        {
            try
            {
                var dbGenre = _context.Genres.FirstOrDefault(x => x.Id == id);
                dbGenre.Name = genre.Name;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: GenreController/Delete/5
        public ActionResult Delete(int id)
        {
            try
            {
                var genre = _context.Genres.FirstOrDefault(x => x.Id == id);
                //var genreVM = new GenreVM
                //{
                //    Id = genre.Id,
                //    Name = genre.Name,
                //};
                var genreVM = _mapper.Map<GenreVM>(genre);

                return View(genreVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: GenreController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, GenreVM genre)
        {
            try
            {
                var dbGenre = _context.Genres.FirstOrDefault(x => x.Id == id);

                _context.Genres.Remove(dbGenre);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    }
}
