﻿using ex13.BL.Models;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using NuGet.Protocol;
using System.Text;

namespace exercise_13.Services
{
    public class Caching : ICaching
    {
        private readonly Exercise13Context _context;
        private readonly IHttpContextAccessor _contextAccessor;

        public Caching(Exercise13Context context, IHttpContextAccessor contextAccessor)
        {
            _context = context;
            _contextAccessor = contextAccessor;
        }

        public List<SelectListItem> GetGenreListItems()
        {
            var httpContext = _contextAccessor.HttpContext;

            var genreListItemsJson = httpContext.Session.GetString("GenreListItems");

            List<SelectListItem> genreListItems;
            if (genreListItemsJson == null)
            {
                genreListItems = _context.Genres
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    }).ToList();

                httpContext.Session.SetString("GenreListItems", genreListItems.ToJson());
            }
            else
            {
                genreListItems = genreListItemsJson.FromJson<List<SelectListItem>>();
            }

            return genreListItems;
        }

        public List<SelectListItem> GetArtistListItems()
        {
            var httpContext = _contextAccessor.HttpContext;

            var artistListItemsJson = httpContext.Session.GetString("ArtistListItems");

            List<SelectListItem> artistListItems;
            if (artistListItemsJson == null)
            {
                artistListItems = _context.Artists
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    }).ToList();

                httpContext.Session.SetString("ArtistListItems", artistListItems.ToJson());
            }
            else
            {
                artistListItems = artistListItemsJson.FromJson<List<SelectListItem>>();
            }

            return artistListItems;
        }

        public List<SelectListItem> GetTagListItems()
        {
            var httpContext = _contextAccessor.HttpContext;

            var tagListItemsJson = httpContext.Session.GetString("TagListItems");

            List<SelectListItem> tagListItems;
            if (tagListItemsJson == null)
            {
                tagListItems = _context.Tags
                    .Select(x => new SelectListItem
                    {
                        Text = x.Name,
                        Value = x.Id.ToString()
                    }).ToList();

                httpContext.Session.SetString("TagListItems", tagListItems.ToJson());
            }
            else
            {
                tagListItems = tagListItemsJson.FromJson<List<SelectListItem>>();
            }

            return tagListItems;
        }

    }
}
