﻿using exercise_12.Models;
using exercise_12.ViewModels;
using Humanizer.Localisation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace exercise_12.Controllers
{
    [Authorize]
    public class ArtistController : Controller
    {
        private readonly Exercise12Context _context;

        public ArtistController(Exercise12Context context)
        {
            _context = context;
        }

        // GET: ArtistController
        public ActionResult Index()
        {
            try
            {
                var artistVms = _context.Artists.Select(x => new ArtistVM
                {
                    Id = x.Id,
                    Name = x.Name,
                }).ToList();

                return View(artistVms);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: ArtistController/Details/5
        public ActionResult Details(int id)
        {
            try
            {
                var artist = _context.Artists.FirstOrDefault(x => x.Id == id);
                var artistVM = new ArtistVM
                {
                    Id = artist.Id,
                    Name = artist.Name,
                };

                return View(artistVM);
            }
            catch (Exception ex)
            {

                throw ex;
            }
        }

        // GET: ArtistController/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: ArtistController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(ArtistVM artist)
        {
            try
            {
                var newArtist = new Artist
                {
                    Name = artist.Name,
                };

                _context.Artists.Add(newArtist);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: ArtistController/Edit/5
        public ActionResult Edit(int id)
        {
            try
            {
                var artist = _context.Artists.FirstOrDefault(x => x.Id == id);
                var artistVM = new ArtistVM
                {
                    Id = artist.Id,
                    Name = artist.Name,
                };

                return View(artistVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: ArtistController/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, ArtistVM artist)
        {
            try
            {
                var dbArtist = _context.Artists.FirstOrDefault(x => x.Id == id);
                dbArtist.Name = artist.Name;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // GET: ArtistController/Delete/5
        public ActionResult Delete(int id)
        {
            try
            {
                var artist = _context.Artists.FirstOrDefault(x => x.Id == id);
                var artistVM = new ArtistVM
                {
                    Id = artist.Id,
                    Name = artist.Name,
                };

                return View(artistVM);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        // POST: ArtistController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, ArtistVM artist)
        {
            try
            {
                var dbArtist = _context.Artists.FirstOrDefault(x => x.Id == id);

                _context.Artists.Remove(dbArtist);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
    }
}
