﻿using exercise_04_01.DTOs;
using exercise_04_01.Models;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace exercise_04_01.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class NotificationTypesController : ControllerBase
    {
        private readonly Exercise4Context _context;

        public NotificationTypesController(Exercise4Context context)
        {
            _context = context;
        }

        // GET: api/<NotificationTypesController>
        [HttpGet]
        public ActionResult<IEnumerable<NotificationTypeDto>> Get()
        {
            try
            {
                var result = _context.NotificationTypes;
                var resultDto = result.Select(x => 
                    new NotificationTypeDto { 
                        Id = x.Id, 
                        Name = x.Name 
                    });

                return Ok(resultDto);
            }
            catch (Exception)
            {
                return BadRequest();
            }
        }

        // GET api/<NotificationTypesController>/5
        [HttpGet("{id}")]
        public ActionResult<NotificationTypeDto> Get(int id)
        {
            try
            {
                var result = _context.NotificationTypes.Include(x => x.Notifications).FirstOrDefault(x => x.Id == id);

                var resultDto = new NotificationTypeDto
                {
                    Id = result.Id,
                    Name = result.Name,
                };

                return Ok(resultDto);
            }
            catch (Exception)
            {
                return BadRequest();
            }
        }

        // POST api/<NotificationTypesController>
        [HttpPost]
        public ActionResult<NotificationTypeDto> Post([FromBody] NotificationTypeDto value)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                var newNotificationType = new NotificationType
                {
                    Name = value.Name,
                };

                _context.NotificationTypes.Add(newNotificationType);

                _context.SaveChanges();

                value.Id = newNotificationType.Id;

                return Ok(value);
            }
            catch (Exception)
            {
                return BadRequest();
            }
        }

        // PUT api/<NotificationTypesController>/5
        [HttpPut("{id}")]
        public ActionResult<NotificationTypeDto> Put(int id, [FromBody] NotificationTypeDto value)
        {
            try
            {
                var result = _context.NotificationTypes.FirstOrDefault(x => x.Id == id);

                result.Name = value.Name;

                _context.SaveChanges();

                value.Id = result.Id;

                return Ok(value);
            }
            catch (Exception)
            {
                return BadRequest();
            }
        }

        // DELETE api/<NotificationTypesController>/5
        [HttpDelete("{id}")]
        public ActionResult<NotificationTypeDto> Delete(int id)
        {
            try
            {
                var result = _context.NotificationTypes.FirstOrDefault(x => x.Id == id);

                var resultDto = new NotificationTypeDto
                {
                    Id = result.Id,
                    Name = result.Name,
                };

                _context.NotificationTypes.Remove(result);

                _context.SaveChanges();

                return Ok(resultDto);
            }
            catch (Exception)
            {
                return BadRequest();
            }
        }
    }
}
