﻿using ex13.BL.Models;
using System.Diagnostics;
using System.IO;

namespace ex13.BL.Services
{
    public class Diagnostics : IDiagnostics
    {
        private readonly Exercise13Context _context;

        public Diagnostics(Exercise13Context context)
        {
            _context = context;
        }

        public int CountArtists()
        {
            return _context.Artists.Count();
        }

        public int CountGenres()
        {
            return _context.Genres.Count();
        }

        public int CountSongs()
        {
            return _context.Audios.Count();
        }

        public int CountTempPathFiles()
        {
            var tempPath = Path.GetTempPath();
            return Directory.GetFiles(tempPath).Length;
        }
    }
}
