﻿using exercise_3_4.Repository;
using exercise_3_8.Models;
using Microsoft.AspNetCore.Mvc;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace exercise_3_8.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class LogsController : ControllerBase
    {
        [HttpGet]
        public ActionResult<IEnumerable<LogItem>> Get(int last = 20)
        {
            try
            {
                var result = LogsRepository.LogItems.TakeLast(last);

                return Ok(result);
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpPost]
        public ActionResult Post([FromBody]LogItem item)
        {
            try
            {
                LogsRepository.LogItems.Add(item);

                return Ok();
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }
    }
}
