﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace exercise_6_1.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class SecuredController : ControllerBase
    {
        // GET: api/<SecuredController>
        [Authorize(Roles = "Admin,User")]
        [HttpGet]
        public ActionResult<string> Get()
        {
            var identity = HttpContext.User.Identity as ClaimsIdentity;
            return identity.FindFirst(ClaimTypes.Name).Value;
        }

        // GET api/<SecuredController>/5
        [Authorize(Roles = "Admin,User")]
        [HttpGet("{id}")]
        public string Get(int id)
        {
            return "value";
        }

        // POST api/<SecuredController>
        [Authorize(Roles = "Admin")]
        [HttpPost]
        public void Post([FromBody] string value)
        {
        }

        // PUT api/<SecuredController>/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/<SecuredController>/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }
    }
}
