﻿using exercise_3_4.Models;
using exercise_3_4.Repository;
using Microsoft.AspNetCore.Mvc;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace exercise_3_4.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class HouseNumberController : ControllerBase
    {
        [HttpGet("{streetId}")]
        public ActionResult<IEnumerable<HouseNumber>> GetNumber(int streetId, int? number, string addendum)
        {
            try
            {
                var street = AddressRepository.Streets.FirstOrDefault(x => x.Id == streetId);
                if (street == null)
                {
                    return NotFound();
                }

                IEnumerable<HouseNumber> retrieved;
                if (!number.HasValue)
                {
                    retrieved = street.HouseNumbers;
                }
                else if (String.IsNullOrEmpty(addendum))
                {
                    retrieved = street.HouseNumbers.Where(x =>
                        x.Number == number);
                }
                else
                {
                    retrieved = street.HouseNumbers.Where(x =>
                        x.Number == number &&
                        x.Addendum == addendum);
                }

                if (!retrieved.Any())
                {
                    return BadRequest($"House number(s) do not exist");
                }

                return Ok(retrieved);
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpPost]
        public ActionResult<HouseNumber> Post([FromBody]HouseNumber houseNumber)
        {
            try
            {
                var street = AddressRepository.Streets.FirstOrDefault(x => x.Id == houseNumber.StreetId);
                if (street == null)
                {
                    return BadRequest($"Street {houseNumber.StreetId} does not exist");
                }

                street.HouseNumbers.Add(houseNumber);

                return houseNumber;
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }

        [HttpDelete("{streetId}")]
        public ActionResult<HouseNumber> Delete(int streetId, int? number, string addendum)
        {
            try
            {
                var street = AddressRepository.Streets.FirstOrDefault(x => x.Id == streetId);
                if (street == null)
                {
                    return BadRequest($"Street {streetId} does not exist");
                }

                int removed = 0;

                if (!number.HasValue)
                {
                    removed = street.HouseNumbers.RemoveAll(x => true);
                }
                else if (String.IsNullOrEmpty(addendum))
                {
                    removed = street.HouseNumbers.RemoveAll(x => 
                        x.Number == number);
                }
                else
                {
                    removed = street.HouseNumbers.RemoveAll(x =>
                        x.Number == number &&
                        x.Addendum == addendum);
                }

                if (removed == 0)
                {
                    return BadRequest($"House number(s) do not exist");
                }

                return Ok();
            }
            catch (Exception)
            {
                return StatusCode(500);
            }
        }
    }
}
