﻿# Solution notes

## Database setup for 6.7

```SQL
CREATE TABLE Receipt (
	Id int NOT NULL IDENTITY (1, 1),
	Code nvarchar(32) NOT NULL,
	Total decimal(18, 2) NOT NULL,
	IssuedAt datetime2(7) NOT NULL,
	CONSTRAINT PK_Receipt PRIMARY KEY CLUSTERED (Id)
)
GO

CREATE TABLE dbo.Product (
	Id int NOT NULL IDENTITY (1, 1),
	Title nvarchar(256) NOT NULL,
	Price decimal(18, 2) NOT NULL,
	CONSTRAINT PK_Product PRIMARY KEY CLUSTERED (Id)
)
GO

CREATE TABLE dbo.ReceiptItem (
	Id int NOT NULL IDENTITY (1, 1),
	ProductId int NOT NULL,
	ReceiptId int NOT NULL,
	Quantity int NOT NULL,
	Price decimal(18, 2) NOT NULL,
	Value decimal(18, 2) NOT NULL,
	CONSTRAINT PK_ReceiptItem PRIMARY KEY CLUSTERED (Id),
	CONSTRAINT FK_ReceiptItem_Product 
		FOREIGN KEY (ProductId) 
		REFERENCES Product (Id),
	CONSTRAINT FK_ReceiptItem_Receipt 
		FOREIGN KEY (ReceiptId) 
		REFERENCES dbo.Receipt (Id)
)
GO
```

## Database setup for 6.9

```
CREATE TABLE [Role] (
	Id int NOT NULL IDENTITY (1, 1),
	[Name] nvarchar(32) NOT NULL,
	CONSTRAINT PK_Role PRIMARY KEY (Id)
)
GO

INSERT INTO [Role] ([Name])
VALUES
	('Admin'),
	('User')
GO

ALTER TABLE [User] 
ADD RoleId int
GO

UPDATE [User]
SET RoleId = (SELECT Id FROM [Role] WHERE [Name] = 'User')
GO

ALTER TABLE [User] 
ADD CONSTRAINT FK_User_Role FOREIGN KEY (RoleId) 
REFERENCES [Role] (Id) 
GO
```