﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Text;

namespace exercise_2_6.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class TextOperationController : ControllerBase
    {
        [HttpGet("[action]")]
        public string RepeatText(string t, int n)
        {
            StringBuilder text = new();
            for (int i = 0; i < n; i++)
            {
                text.Append(t);
            }

            return text.ToString();
        }

        [HttpGet("[action]")]
        public char MostFrequentCharacter(string sentence)
        {
            // "let's find the most frequent letter"
            //   => 6 e's

            if (sentence.Length == 0)
                return '\0'; // return empty character

            var dict = GetHistogramDictionary(sentence);

            var mostFrequent = dict.OrderByDescending(x => x.Value).First();
            return mostFrequent.Key;
        }

        private static Dictionary<char, int> GetHistogramDictionary(string sentence)
        {
            var dict = new Dictionary<char, int>();
            foreach (var letter in sentence)
            {
                if (!dict.ContainsKey(letter))
                {
                    dict[letter] = 0;
                }
                dict[letter]++;
            }

            return dict;
        }

        private static string Sentence { get; set; }

        [HttpGet("[action]")]
        public void SetSentence(string sentence)
        {
            Sentence = sentence;
        }

        [HttpGet("[action]")]
        public int CharacterFrequency(char letter)
        {
            var dict = GetHistogramDictionary(Sentence);

            if (dict.ContainsKey(letter))
                return dict[letter];
            else
                return '\0';
        }

        private static char ShiftChar(char c, int offset, int shift)
        {
            var idx = (int)c;
            idx -= offset;
            idx += shift % 26;
            idx %= 26;
            idx += offset;
            return (char)idx;
        }

        [HttpGet("[action]")]
        public string Rot13(string text)
        {
            var result = new StringBuilder();
            int shift = 13;
            int a_idx = 97;
            int A_idx = 65;
            for (int i = 0; i < text.Length; i++)
            {
                char c = text[i];
                if (c >= a_idx && c < (a_idx + 26))
                {
                    c = ShiftChar(c, a_idx, shift);
                }
                else if (c >= A_idx && c < (A_idx + 26))
                {
                    c = ShiftChar(c, A_idx, shift);
                }
                result.Append((char)c);
            }
            return result.ToString();
        }
    }
}
