﻿using exercise_9_1.Models;
using exercise_9_1.ViewModels;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;

namespace exercise_9_1.Controllers
{
    public class GenreController : Controller
    {
        private readonly Exercise9Context _context;

        public GenreController(Exercise9Context context)
        {
            _context = context;
        }

        // GET: GenreController
        public ActionResult Index()
        {
            ViewBag.Genres = _context.Genres;

            ViewBag.GenreDropDownItems =
                _context.Genres.Select(x => new SelectListItem { Text = x.Name, Value = x.Id.ToString() });

            return View();
        }

        [HttpPost]
        public ActionResult Index(string ExampleText, string GenreDropDownItems)
        {
            return RedirectToAction();
        }

        // GET: GenreController/Details/5
        public ActionResult Details(int id)
        {
            var genre = _context.Genres.FirstOrDefault(x => x.Id == id);

            // Map to VM
            var genreVM = new GenreVM
            {
                Id = genre.Id,
                Name = genre.Name,
                Description = genre.Description,
            };

            return View(genreVM);
        }

        // GET: GenreController/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: GenreController/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create(GenreVM genre)
        {
            try
            {
                var newGenre = new Genre
                {
                    Name = genre.Name,
                    Description = genre.Description,
                };

                _context.Genres.Add(newGenre);

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: GenreController/Edit/5
        public ActionResult Edit(int id)
        {
            var genre = _context.Genres.FirstOrDefault(x => x.Id == id);

            // Map to VM
            var genreVM = new GenreVM
            {
                Id = genre.Id,
                Name = genre.Name,
                Description = genre.Description,
            };

            return View(genreVM);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(int id, GenreVM genre)
        {
            try
            {
                var dbGenre = _context.Genres.FirstOrDefault(x => x.Id == id);
                dbGenre.Name = genre.Name;
                dbGenre.Description = genre.Description;

                _context.SaveChanges();

                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }

        // GET: GenreController/Delete/5
        public ActionResult Delete(int id)
        {
            return View();
        }

        // POST: GenreController/Delete/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Delete(int id, Genre genre)
        {
            try
            {
                return RedirectToAction(nameof(Index));
            }
            catch
            {
                return View();
            }
        }
    }
}
