﻿using Microsoft.AspNetCore.DataProtection.AuthenticatedEncryption.ConfigurationModel;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace exercise_2_6.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class StatefulController : ControllerBase
    {
        // If static, the member will be maintained between requests.
        // Instance member will not be maintained because the instance will
        // be created on each request, and so will instance members.
        private static int State { get; set; } = 0;

        [HttpGet("[action]")]
        public void Add()
        {
            State++;
        }

        [HttpGet("[action]")]
        public int GetState()
        { 
            return State;
        }

        [HttpGet("[action]")]
        public decimal Average(int number)
        {
            var sum = 0;
            for (int i = 1; i <= number; i++)
            {
                sum += i;
            }
            return (decimal)sum / number;
        }

        public static int NthFibonacci { get; set; }

        [HttpGet("[action]")]
        public int Fibonacci(int n)
        {
            int f1 = 0;
            int f2 = 1;
            int f = 1;

            if (n == 0)
                return f1;
            else if(n == 1)
                return f2;

            for (int i = 2; i <= n; i++)
            {
                f = f1 + f2;

                f1 = f2;
                f2 = f;
            }

            NthFibonacci = f;
            
            return f;
        }

        [HttpGet("[action]")]
        public int LastFibonacci()
        {
            return NthFibonacci;
        }

    }
}
