﻿using exercise_07.Dtos;
using exercise_07.Mapping;
using exercise_07.Models;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;

namespace exercise_07.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class GenreController : ControllerBase
    {
        private readonly Exercise7Context _dbContext;

        public GenreController(Exercise7Context dbContext)
        {
            _dbContext = dbContext;
        }

        [HttpGet("[action]")]
        [Authorize]
        public ActionResult<IEnumerable<AudioDto>> GetAll()
        {
            try
            {
                var dbGenres = _dbContext.Genres;

                var genres = GenreMapping.MapToBL(dbGenres);

                return Ok(genres);
            }
            catch (Exception ex)
            {
                return StatusCode(
                    StatusCodes.Status500InternalServerError,
                    "There has been a problem while fetching the data you requested");
            }
        }
    }
}
