﻿using ex13.BL.Services;
using exercise_13.ViewModels;
using Microsoft.AspNetCore.Mvc;

namespace exercise_13.Controllers
{
    public class DiagnosticsController : Controller
    {
        public readonly IDiagnostics _diagnostics;

        public DiagnosticsController(IDiagnostics diagnostics)
        {
            _diagnostics = diagnostics;
        }

        public IActionResult Index()
        {
            var diagVm = new DiagnosticsVM
            {
                SongCount = _diagnostics.CountSongs(),
                TempPathFileCount = _diagnostics.CountTempPathFiles(),
                ArtistCount = _diagnostics.CountArtists(),
                GenreCount = _diagnostics.CountGenres(),
            };

            return View(diagVm);
        }
    }
}
