﻿// Template HTML generator function for toast message
const createToastTemplate = (title, info, body) =>
    `<div class="toast show">
      <div class="toast-header">
          <strong class="me-auto">${title}</strong>
          <small>${info}</small>
          <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
      </div>
      <div class="toast-body">
          ${body}
      </div>
  </div>`

// Function that creates toast DOM from HTML and instances a new Bootstrap toast
function createToast(title, info, body, delay = null) {
    const toastTemplate = createToastTemplate(title, info, body);

    const placeholder = document.createElement("div");
    placeholder.innerHTML = toastTemplate;
    const toastEl = placeholder.firstElementChild;

    var toastPh = document.getElementById('toast-placeholder');
    toastPh.append(toastEl);

    var visibleToast = new bootstrap.Toast(toastEl, { 'autohide': true, 'delay': delay });
    visibleToast.show();
}

