﻿using ex13.BL.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ex13.BL.Services
{
    public class AudioRepository : IAudioRepository
    {
        private readonly Exercise13Context _context;
        
        public AudioRepository(Exercise13Context context)
        {
            _context = context;
        }

        public IEnumerable<Audio> GetAll()
        {
            var songs = _context.Audios
                .Include(x => x.Genre)
                .Include(x => x.Artist)
                .Include(x => x.AudioTags);

            return songs;
        }

        public Audio Get(int id)
        {
            var song = _context.Audios
                .Include(x => x.Genre)
                .Include(x => x.Artist)
                .Include(x => x.AudioTags)
                .FirstOrDefault(x => x.Id == id);

            return song;
        }

        public Audio Add(string title, int? year, int genreId, int artistId, int duration, string url)
        {
            var audio = new Audio
            {
                Title = title,
                Year = year,
                GenreId = genreId,
                ArtistId = artistId,
                Duration = duration,
                Url = url
            };

            _context.Audios.Add(audio);

            _context.SaveChanges();

            return audio;
        }

        public Audio Modify(int id, string title, int? year, int genreId, int artistId, int duration, string url, IEnumerable<int> tagIds)
        {
            var audio = _context.Audios.Include(x => x.AudioTags).FirstOrDefault(x => x.Id == id);
            audio.Title = title;
            audio.Year = year;
            audio.GenreId = genreId;
            audio.ArtistId = artistId;
            audio.Duration = duration;
            audio.Url = url;

            _context.RemoveRange(audio.AudioTags);
            var audioTags = tagIds.Select(x => new AudioTag { AudioId = id, TagId = x });
            foreach (var tag in audioTags)
            {
                audio.AudioTags.Add(tag);
            }

            _context.SaveChanges();

            return audio;
        }

        public Audio Remove(int id)
        {
            var audio = _context.Audios
                .Include(x => x.AudioTags)
                .FirstOrDefault(x => x.Id == id);

            _context.RemoveRange(audio.AudioTags);
            _context.Audios.Remove(audio);

            _context.SaveChanges();

            return audio;
        }
    }
}
