﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    class Document : ISignable
    {
        public string Title { get; set; }
        public string Text { get; set; }
        // no one should sign but Dean - it is not in the requirement
        public bool Signed { get; private set; }
        public void Sign() => Signed = true;
        public override string ToString() => $"Title: {Title}, Text: {Text}, Signed: {(Signed? "yes" : "no")}";
    }
}
