﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    // we could have implemented IComparable, with no generic type Book, but our method would then take an object to compare, not the Book!!!
    //public int CompareTo(object obj){}
    // but we want to compare only books!
    class Book : IComparable<Book>
    {
        // static belongs to a class, not an object!
        private static int idGenerator;
        // readonly field can be modified only in the constructor!
        private readonly int id;

        private long isbn;
        public long Isbn
        {
            get => isbn;
            set
            {
                // following is an example of lambda:
                // value.ToString().All(c => char.IsDigit(c)))
                // and can be reduced to "method reference":
                // value.ToString().All(char.IsDigit)
                if (value.ToString().Length != 13 || !value.ToString().All(char.IsDigit))
                {
                    throw new Exception("ISBN length must be 13 digits!");
                }
                isbn = value;
            }
        }
        public string Title { get; set; }
        public string Author { get; set; }
        public Book(long isbn, string title, string author)
        {
            id = ++idGenerator;
            Isbn = isbn;
            Title = title;
            Author = author;
        }
        public override string ToString() => $"Book: {id}\t{Isbn}\t{Title}\t{Author}";

        // since we want to compare long values and long implements IComparable<long>, we can use his CompareTo() method!
        public int CompareTo(Book other) => -Isbn.CompareTo(other.Isbn);
        //{
        //    if (Isbn > other.Isbn)
        //    {
        //        return -1;
        //    } else if (Isbn < other.Isbn)
        //    {
        //        return 1;
        //    }
        //    // 0 means that the objects are same in ordering sense
        //    return 0;
        //}
    }
}
