﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode.Model
{
    class Student : Person, IComparable<Student>
    {
        public enum StudentType
        {
            Parttime = 1,
            Regular
        }
        private static int idGenerator;
        private readonly int id;
        public StudentType Type { get; set; }
        public Student(string firstName, string lastName, StudentType type) : base(firstName, lastName)
        {
            id = ++idGenerator;
            Type = type;
        }
        public override string ToString() => $"Id: {id}, {base.ToString()}, Type: {Type}";
        public override bool Equals(object obj) => obj is Student other ? id == other.id : false;
        public override int GetHashCode() => id.GetHashCode();
        public int CompareTo(Student other) => -id.CompareTo(other.id);
    }
}
