﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    class Program
    {
        static void Main(string[] args)
        {
            // seems there is a Read method on the Console that returns integer
            //Console.WriteLine(Console.Read());
            // but it reads first character from console as ASCII integer
            // it is not good for us! we need actual integer
            // this could be a solution, but it returns string:
            //Console.WriteLine(Console.ReadLine());
            // so we must parse it!
            //Console.WriteLine(int.Parse(Console.ReadLine())); 
            // seems it is working, but throws FormatException when not integer - exceptions as a mechanism to notify the caller (instead of int as return value from main function in c++)
            // we'll deal with it later!

            Console.Write("Insert first number: ");
            int a = int.Parse(Console.ReadLine());
            // ctrl + d -> duplicate
            Console.Write("Insert second number: ");
            int b = int.Parse(Console.ReadLine());

            // this does not work -> a + b is concatenated, not added!
            //Console.WriteLine(a + " + " + b + " = " + a + b);
            // why is this working?
            //Console.WriteLine(a + b + " = " + a + " + " + b); 
            //Console.WriteLine(a + b);
            // so we must use parentheses
            //Console.WriteLine(a + " + " + b + " = " + (a + b));
            // same for subtraction!
            //Console.WriteLine(a + " - " + b + " = " + (a - b));
            // but not for multiply and divide. why?
            //Console.WriteLine(a + " * " + b + " = " + a * b);
            //Console.WriteLine(a + " / " + b + " = " + a / b);
            // why the result is not double?

            // is there a better way to print?
            //Console.WriteLine("{0} * {1} = {2}", a, b, a * b);
            //Console.WriteLine("{0} / {1} = {2}", a, b, a / b);
            // it is dangerous because it throws FormatException
            //Console.WriteLine("{0} / {1} = {2}", a, b);

            // is there a better way?
            // interpolated strings to the rescue!!!
            Console.WriteLine($"{a} * {b} = {a * b}");
            Console.WriteLine($"{a} / {b} = {a / b}");

            // but what about a special characters: { }?
            Console.WriteLine($"{{test}}");

            // how can we put "?
            Console.WriteLine("\"test\"");
            // how can we put \?
            Console.WriteLine("\\test\\");

            // finally - what about Console.ReadKey?
            //ConsoleKeyInfo consoleKeyInfo = Console.ReadKey();
            //Console.WriteLine(consoleKeyInfo.KeyChar);

            // can be used in debug mode, to prevent closing the window
            Console.ReadKey();
        }
    }
}
