﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    class Program
    {
        static void Main(string[] args)
        {
            Car car = new Car(123, "Mercedes", 8.5);
            car.Drive();
            car.Stop();
            Console.WriteLine(car);
            Console.WriteLine("-------------------------------------------------");

            SportsCar sportsCar = new SportsCar(321, "Ferrari", 3.5, true);
            sportsCar.Drive();
            sportsCar.Drift();
            sportsCar.Stop();
            Console.WriteLine(sportsCar);
            Console.WriteLine("-------------------------------------------------");

            // implicit upcast - every SportsCar is a Car!
            Car car2 = sportsCar;
            car2.Drive();
            car2.Stop();

            // explicit downcast - not every Car is a SportsCar!
            //SportsCar sportsCar2 = (SportsCar)car; // explicit cast is dangerous!
            if (car2 is SportsCar sportsCar2)
            {
                sportsCar2.Drift();
            }
            Console.WriteLine("-------------------------------------------------");

            // benefits of polymorphism:
            // 1. unique list for all the cars
            // left side is not specific -> can be any IList<Car> (they all behave the same), right side is specific List<Car>
            IList<Car> cars = new List<Car>
            {
                car,
                sportsCar,
                new Truck(213, "Scania", 19.6, 100)
            };
            foreach (var c in cars)
            {
                c.Drive();
                c.Stop();
                if (c is SportsCar sc2)
                {
                    sc2.Drift();
                }
                // 2. unique method for all cars
                PrintDetails(c);
            }

            // we can not add Motorcycle -> we are too concrete with the car!
            // we should have had abstract Vehicle as parent of Car!
        }
        private static void PrintDetails(Car c) => Console.WriteLine(c);
    }
    
}
