﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    class SportsCar : Car
    {
        // constructors are not inherited
        // this is implicit constructor and does not work, because the parent does not have default parameterless constructor
        //public SportsCar() : base() 
        //{
        //}
        public bool RoofWindow { get; set; }
        // we must override constructors, because constructors are not inherited, and we must put the parent in consistent state!
        // constructor can also be expression method!
        public SportsCar(int number, string type, double acceleration, bool roofWindow) : base(number, type, acceleration) => RoofWindow = roofWindow;

        public void Drift() => Console.WriteLine("Sports car drifting");
        // Drive() and Stop() do not reuse parent's implementation!
        public override void Drive() => Console.WriteLine("Sports car driving");
        public override void Stop() => Console.WriteLine("Sports car stopping");
        // ToString() reuses parent's implementation!
        public override string ToString() => $"{base.ToString()}, Roof window: {(RoofWindow ? "yes" : "no")}";

    }
}
