﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    class Program
    {
        static void Main(string[] args)
        {
            Book b1 = new Book(1234567890123, "Bez sudbine", "Imre Kertesz");
            //Console.WriteLine(b1);
            Book b2 = new Book(4567890123123, "Praznina", "Daniel Bele");
            Book b3 = new Book(2334567890121, "Painted Bird", "Jerzy Kosinski");

            // we use List<Book> instead of IList<Book> because it greatly simplifies the code
            List<Book> books = new List<Book>
            {
                b1,
                b2,
                b3
            };
            Console.WriteLine("Unsorted:");
            //foreach (var book in books)
            //{
            //    Console.WriteLine(book);
            //}
            // using lambda:
            // books.ForEach(s => Console.WriteLine(s));
            // using "method reference":
            books.ForEach(Console.WriteLine);
            Console.WriteLine("--------------------------------------------------------");

            IntsDemo();
            
            Console.WriteLine("ISBN descending:");
            books.Sort();
            books.ForEach(Console.WriteLine);
            Console.WriteLine("--------------------------------------------------------");
            
            Console.WriteLine("Author ascending:");
            // sort method has overloaded version that takes IComparer implementation
            books.Sort(new BookAuthorAscComparer());
            books.ForEach(Console.WriteLine);
            Console.WriteLine("--------------------------------------------------------");

            Console.WriteLine("Title descending:");
            // we can use lambda instead of concrete class implementation
            books.Sort((x, y) => -x.Title.CompareTo(y.Title));
            books.ForEach(Console.WriteLine);
            Console.WriteLine("--------------------------------------------------------");
        }

        private static void IntsDemo()
        {
            // the proof that c# relies highly on interfaces!
            List<int> ints = new List<int>
            {
                1, 5, 0
            };
            // integers can be sorted because int implements IComparable<int>
            ints.Sort();
            ints.ForEach(Console.WriteLine);
            Console.WriteLine("--------------------------------------------------------");
        }
    }
}
