﻿using CleanCode.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CleanCode
{
    class Program
    {
        static void Main(string[] args)
        {
            List<Student> list = new List<Student>();
            Student student = new Student("milica", "krmpotic", Student.StudentType.Regular);
            list.Add(student);
            //this works also for the default implementation (references), but ok! - we are testing the same student!
            Console.WriteLine($"Equals: {student.Equals(list[0])}");
            Student student2 = new Student("daniel", "bele", Student.StudentType.Parttime);
            list.Add(student2);
            Student student3 = new Student("john", "wayne", Student.StudentType.Parttime);
            list.Add(student3);
            Console.WriteLine("unsorted students:");
            list.ForEach(Console.WriteLine);
            Console.WriteLine("students sorted by id desc:");
            list.Sort();
            list.ForEach(Console.WriteLine);
            Console.WriteLine("students sorted by surname asc:");
            list.Sort(new StudentLastNameAscComparator());
            list.Sort((x, y) => x.LastName.CompareTo(y.LastName));
            list.ForEach(Console.WriteLine);
            Console.WriteLine("Subjects ----------------------------------------------");
            Subject subject = new Subject
            {
                Code = "123",
                Points = 30,
                Title = "OOP"
            };
            Console.WriteLine(subject);
            Console.WriteLine("Teachers ----------------------------------------------");
            Teacher assistent = new Teacher("Assistentus", "Assistentis", subject);
            Teacher professor = new Teacher("Professorus", "Professoris", subject);
            Console.WriteLine(assistent);
            Console.WriteLine(professor);
            Console.WriteLine("Dean ----------------------------------------------");
            Dean dean = new Dean("Dean", "Martin", "Da dean");
            Console.WriteLine(dean);
            List<Person> persons = new List<Person>
            {
                student,
                student2,
                student3,
                assistent,
                professor,
                dean
            };
            Console.WriteLine($"All persons: {persons.Count}");
            Console.WriteLine("Document ----------------------------------------------");
            Document document = new Document
            {
                Title = "Test document",
                Text = "simple text"
            };
            Console.WriteLine(document);
            Console.WriteLine("Signing -----------------------------------------------");
            List<ISignable> listToSign = new List<ISignable>
            {
                subject,
                document
            };
            listToSign.ForEach(dean.GiveSign);
            listToSign.ForEach(Console.WriteLine);
        }
    }
}
